package com.ejie.ab04b.model;

import java.util.Date;
import java.util.List;

import org.apache.commons.lang.StringUtils;
import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;

import com.ejie.x38.serialization.JsonDateDeserializer;
import com.ejie.x38.serialization.JsonDateSerializer;

/**
 * OS3 generated by UDA, 28-feb-2017 11:23:11.
 * 
 * @author UDA
 */

public class OS3 extends ComunicacionProcedimiento
		implements java.io.Serializable {

	private static final long serialVersionUID = 1L;

	private static final int NUMEXP_LPAD_SIZE = 5;
	private static final String NUMEXP_LPAD_CHAR = "0";

	private String teros3061;
	private String anoos3061;
	private Integer numos3061;

	private Date fecpre061;
	private Date fecier061;
	private String terape061;
	private String anoape061;
	private Integer numape061;
	private String nueva061;
	private String tipdoc061;
	private String numdoc061;
	private String nomemp061;
	private String paisemp061;
	private String prvemp061;
	private String munemp061;
	private String dmunemp061;
	private String diremp061;
	private String cpoemp061;
	private String tlfemp061;
	private String faxemp061;
	private String emaemp061;
	private String httpemp061;
	private String clasctr061;
	private Long trbtot061;
	private String declar061;
	private String cardec061;
	private Date fecevr061;
	private String desrie061;
	private String desact061;
	private String observ061;
	private Integer codctr061;
	private Date fecalt061;
	private String usualt061;
	private Date fecmod061;
	private String usumod061;
	private String descemp061;
	private String doccorrecta061;
	private String estado061;
	private String forpre061;
	private String migrado061;
	private String folderid061;
	private String coddatosnotif061;
	private String usuarioApe061;
	private String usuarioAport061;
	private String usuarioTram061;

	private DatosNotificacion datosNotificacion;

	private String numdocrepresentante061;
	private String tlfrepresentante061;
	private String titRepr061;
	private String nomrepresentante061;
	private String tipdocrepresentante061;

	private List<TramiteOS3> listaTramites;
	private List<TareaOS3> listaTareas;

	private String deseaRegistrar061;
	private String numReg061;
	private Date fecReg061;

	// Añadidos filtro
	private String numExpDesde;
	private String numExpHasta;
	private Date fecpreDesde;
	private Date fecpreHasta;
	private String periodoPresentacion;

	private Date fecreq061;
	private Date fecsub061;

	/**
	 * Method 'OS3'.
	 */
	public OS3() {
	}

	/**
	 * Method 'OS3'.
	 * 
	 * teros3061 String anoos3061 String numos3061 Integer
	 *
	 * @param teros3061
	 *            the teros 3061
	 * @param anoos3061
	 *            the anoos 3061
	 * @param numos3061
	 *            the numos 3061
	 */
	public OS3(String teros3061, String anoos3061, Integer numos3061) {
		this.teros3061 = teros3061;
		this.anoos3061 = anoos3061;
		this.numos3061 = numos3061;
	}

	/**
	 * Method 'OS3'.
	 * 
	 * teros3061 String anoos3061 String numos3061 Integer fecpre061 Date
	 * fecier061 Date terape061 String anoape061 String numape061 Integer
	 * nueva061 String tipdoc061 String numdoc061 String nomemp061 String
	 * paisemp061 String prvemp061 String munemp061 String dmunemp061 String
	 * diremp061 String cpoemp061 String tlfemp061 String faxemp061 String
	 * emaemp061 String httpemp061 String clasctr061 String trbtot061 Long
	 * declar061 String cardec061 String fecevr061 Date desrie061 String
	 * desact061 String observ061 String codctr061 Integer fecalt061 Date
	 * usualt061 String fecmod061 Date usumod061 String descemp061 String
	 * doccorrecta061 String estado061 String forpre061 String migrado061 String
	 * folderid061 String coddatosnotif061 String datosNotificacion
	 * DatosNotificacion numdocrepresentante061 String tlfrepresentante061
	 * String titRepr061 String nomrepresentante061 String
	 * tipdocrepresentante061 String usuarioApe the usuario ape usuarioAport the
	 * usuario aport usuarioTram the usuario tram
	 *
	 * @param teros3061
	 *            the teros 3061
	 * @param anoos3061
	 *            the anoos 3061
	 * @param numos3061
	 *            the numos 3061
	 * @param fecpre061
	 *            the fecpre 061
	 * @param fecier061
	 *            the fecier 061
	 * @param terape061
	 *            the terape 061
	 * @param anoape061
	 *            the anoape 061
	 * @param numape061
	 *            the numape 061
	 * @param nueva061
	 *            the nueva 061
	 * @param tipdoc061
	 *            the tipdoc 061
	 * @param numdoc061
	 *            the numdoc 061
	 * @param nomemp061
	 *            the nomemp 061
	 * @param paisemp061
	 *            the paisemp 061
	 * @param prvemp061
	 *            the prvemp 061
	 * @param munemp061
	 *            the munemp 061
	 * @param dmunemp061
	 *            the dmunemp 061
	 * @param diremp061
	 *            the diremp 061
	 * @param cpoemp061
	 *            the cpoemp 061
	 * @param tlfemp061
	 *            the tlfemp 061
	 * @param faxemp061
	 *            the faxemp 061
	 * @param emaemp061
	 *            the emaemp 061
	 * @param httpemp061
	 *            the httpemp 061
	 * @param clasctr061
	 *            the clasctr 061
	 * @param trbtot061
	 *            the trbtot 061
	 * @param declar061
	 *            the declar 061
	 * @param cardec061
	 *            the cardec 061
	 * @param fecevr061
	 *            the fecevr 061
	 * @param desrie061
	 *            the desrie 061
	 * @param desact061
	 *            the desact 061
	 * @param observ061
	 *            the observ 061
	 * @param codctr061
	 *            the codctr 061
	 * @param fecalt061
	 *            the fecalt 061
	 * @param usualt061
	 *            the usualt 061
	 * @param fecmod061
	 *            the fecmod 061
	 * @param usumod061
	 *            the usumod 061
	 * @param descemp061
	 *            the descemp 061
	 * @param doccorrecta061
	 *            the doccorrecta 061
	 * @param estado061
	 *            the estado 061
	 * @param forpre061
	 *            the forpre 061
	 * @param migrado061
	 *            the migrado 061
	 * @param folderid061
	 *            the folderid 061
	 * @param coddatosnotif061
	 *            the coddatosnotif 061
	 * @param datosNotificacion
	 *            the datos notificacion
	 * @param numdocrepresentante061
	 *            the numdocrepresentante 061
	 * @param tlfrepresentante061
	 *            the tlfrepresentante 061
	 * @param titRepr061
	 *            the tit repr 061
	 * @param nomrepresentante061
	 *            the nomrepresentante 061
	 * @param tipdocrepresentante061
	 *            the tipdocrepresentante 061
	 * @param usuarioApe
	 *            the usuario ape
	 * @param usuarioAport
	 *            the usuario aport
	 * @param usuarioTram
	 *            the usuario tram
	 */
	public OS3(String teros3061, String anoos3061, Integer numos3061,
			Date fecpre061, Date fecier061, String terape061, String anoape061,
			Integer numape061, String nueva061, String tipdoc061,
			String numdoc061, String nomemp061, String paisemp061,
			String prvemp061, String munemp061, String dmunemp061,
			String diremp061, String cpoemp061, String tlfemp061,
			String faxemp061, String emaemp061, String httpemp061,
			String clasctr061, Long trbtot061, String declar061,
			String cardec061, Date fecevr061, String desrie061,
			String desact061, String observ061, Integer codctr061,
			Date fecalt061, String usualt061, Date fecmod061, String usumod061,
			String descemp061, String doccorrecta061, String estado061,
			String forpre061, String migrado061, String folderid061,
			String coddatosnotif061, DatosNotificacion datosNotificacion,
			String numdocrepresentante061, String tlfrepresentante061,
			String titRepr061, String nomrepresentante061,
			String tipdocrepresentante061, String usuarioApe,
			String usuarioAport, String usuarioTram, Date fecsub061,
			Date fecreq061) {
		this.teros3061 = teros3061;
		this.anoos3061 = anoos3061;
		this.numos3061 = numos3061;
		this.fecpre061 = fecpre061;
		this.fecier061 = fecier061;
		this.terape061 = terape061;
		this.anoape061 = anoape061;
		this.numape061 = numape061;
		this.nueva061 = nueva061;
		this.tipdoc061 = tipdoc061;
		this.numdoc061 = numdoc061;
		this.nomemp061 = nomemp061;
		this.paisemp061 = paisemp061;
		this.prvemp061 = prvemp061;
		this.munemp061 = munemp061;
		this.dmunemp061 = dmunemp061;
		this.diremp061 = diremp061;
		this.cpoemp061 = cpoemp061;
		this.tlfemp061 = tlfemp061;
		this.faxemp061 = faxemp061;
		this.emaemp061 = emaemp061;
		this.httpemp061 = httpemp061;
		this.clasctr061 = clasctr061;
		this.trbtot061 = trbtot061;
		this.declar061 = declar061;
		this.cardec061 = cardec061;
		this.fecevr061 = fecevr061;
		this.desrie061 = desrie061;
		this.desact061 = desact061;
		this.observ061 = observ061;
		this.codctr061 = codctr061;
		this.fecalt061 = fecalt061;
		this.usualt061 = usualt061;
		this.fecmod061 = fecmod061;
		this.usumod061 = usumod061;
		this.descemp061 = descemp061;
		this.doccorrecta061 = doccorrecta061;
		this.estado061 = estado061;
		this.forpre061 = forpre061;
		this.migrado061 = migrado061;
		this.folderid061 = folderid061;
		this.coddatosnotif061 = coddatosnotif061;
		this.datosNotificacion = datosNotificacion;

		this.numdocrepresentante061 = numdocrepresentante061;
		this.tlfrepresentante061 = tlfrepresentante061;
		this.titRepr061 = titRepr061;
		this.nomrepresentante061 = nomrepresentante061;
		this.tipdocrepresentante061 = tipdocrepresentante061;

		this.usuarioApe061 = usuarioApe;
		this.usuarioAport061 = usuarioAport;
		this.usuarioTram061 = usuarioTram;

		this.fecreq061 = fecreq061;
		this.fecsub061 = fecsub061;
	}

	/**
	 * Method 'getTeros3061'.
	 * 
	 * String
	 *
	 * @return the teros 3061
	 */

	public String getTeros3061() {
		return this.teros3061;
	}

	/**
	 * Method 'setTeros3061'.
	 * 
	 * teros3061 String
	 *
	 * @param teros3061
	 *            the new teros 3061
	 */

	public void setTeros3061(String teros3061) {
		this.teros3061 = teros3061;
	}

	/**
	 * Method 'getAnoos3061'.
	 * 
	 * String
	 *
	 * @return the anoos 3061
	 */

	public String getAnoos3061() {
		return this.anoos3061;
	}

	/**
	 * Method 'setAnoos3061'.
	 * 
	 * anoos3061 String
	 *
	 * @param anoos3061
	 *            the new anoos 3061
	 */

	public void setAnoos3061(String anoos3061) {
		this.anoos3061 = anoos3061;
	}

	/**
	 * Method 'getNumos3061'.
	 * 
	 * Integer
	 *
	 * @return the numos 3061
	 */

	public Integer getNumos3061() {
		return this.numos3061;
	}

	/**
	 * Method 'setNumos3061'.
	 * 
	 * numos3061 Integer
	 *
	 * @param numos3061
	 *            the new numos 3061
	 */

	public void setNumos3061(Integer numos3061) {
		this.numos3061 = numos3061;
	}

	/**
	 * Method 'getFecpre061'.
	 * 
	 * java.util.Date
	 *
	 * @return the fecpre 061
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getFecpre061() {
		return this.fecpre061;
	}

	/**
	 * Method 'setFecpre061'.
	 * 
	 * fecpre061 java.util.Date
	 *
	 * @param fecpre061
	 *            the new fecpre 061
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setFecpre061(Date fecpre061) {
		this.fecpre061 = fecpre061;
	}

	/**
	 * Method 'getFecier061'.
	 * 
	 * java.util.Date
	 *
	 * @return the fecier 061
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getFecier061() {
		return this.fecier061;
	}

	/**
	 * Method 'setFecier061'.
	 * 
	 * fecier061 java.util.Date
	 *
	 * @param fecier061
	 *            the new fecier 061
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setFecier061(Date fecier061) {
		this.fecier061 = fecier061;
	}

	/**
	 * Method 'getTerape061'.
	 * 
	 * String
	 *
	 * @return the terape 061
	 */

	public String getTerape061() {
		return this.terape061;
	}

	/**
	 * Method 'setTerape061'.
	 * 
	 * terape061 String
	 *
	 * @param terape061
	 *            the new terape 061
	 */

	public void setTerape061(String terape061) {
		this.terape061 = terape061;
	}

	/**
	 * Method 'getAnoape061'.
	 * 
	 * String
	 *
	 * @return the anoape 061
	 */

	public String getAnoape061() {
		return this.anoape061;
	}

	/**
	 * Method 'setAnoape061'.
	 * 
	 * anoape061 String
	 *
	 * @param anoape061
	 *            the new anoape 061
	 */

	public void setAnoape061(String anoape061) {
		this.anoape061 = anoape061;
	}

	/**
	 * Method 'getNumape061'.
	 * 
	 * Integer
	 *
	 * @return the numape 061
	 */

	public Integer getNumape061() {
		return this.numape061;
	}

	/**
	 * Method 'setNumape061'.
	 * 
	 * numape061 Integer
	 *
	 * @param numape061
	 *            the new numape 061
	 */

	public void setNumape061(Integer numape061) {
		this.numape061 = numape061;
	}

	/**
	 * Method 'getNueva061'.
	 * 
	 * String
	 *
	 * @return the nueva 061
	 */

	public String getNueva061() {
		return this.nueva061;
	}

	/**
	 * Method 'setNueva061'.
	 * 
	 * nueva061 String
	 *
	 * @param nueva061
	 *            the new nueva 061
	 */

	public void setNueva061(String nueva061) {
		this.nueva061 = nueva061;
	}

	/**
	 * Method 'getTipdoc061'.
	 * 
	 * String
	 *
	 * @return the tipdoc 061
	 */

	public String getTipdoc061() {
		return this.tipdoc061;
	}

	/**
	 * Method 'setTipdoc061'.
	 * 
	 * tipdoc061 String
	 *
	 * @param tipdoc061
	 *            the new tipdoc 061
	 */

	public void setTipdoc061(String tipdoc061) {
		this.tipdoc061 = tipdoc061;
	}

	/**
	 * Method 'getNumdoc061'.
	 * 
	 * String
	 *
	 * @return the numdoc 061
	 */

	public String getNumdoc061() {
		return this.numdoc061;
	}

	/**
	 * Method 'setNumdoc061'.
	 * 
	 * numdoc061 String
	 *
	 * @param numdoc061
	 *            the new numdoc 061
	 */

	public void setNumdoc061(String numdoc061) {
		this.numdoc061 = numdoc061;
	}

	/**
	 * Method 'getNomemp061'.
	 * 
	 * String
	 *
	 * @return the nomemp 061
	 */

	public String getNomemp061() {
		return this.nomemp061;
	}

	/**
	 * Method 'setNomemp061'.
	 * 
	 * nomemp061 String
	 *
	 * @param nomemp061
	 *            the new nomemp 061
	 */

	public void setNomemp061(String nomemp061) {
		this.nomemp061 = nomemp061;
	}

	/**
	 * Method 'getPaisemp061'.
	 * 
	 * String
	 *
	 * @return the paisemp 061
	 */

	public String getPaisemp061() {
		return this.paisemp061;
	}

	/**
	 * Method 'setPaisemp061'.
	 * 
	 * paisemp061 String
	 *
	 * @param paisemp061
	 *            the new paisemp 061
	 */

	public void setPaisemp061(String paisemp061) {
		this.paisemp061 = paisemp061;
	}

	/**
	 * Method 'getPrvemp061'.
	 * 
	 * String
	 *
	 * @return the prvemp 061
	 */

	public String getPrvemp061() {
		return this.prvemp061;
	}

	/**
	 * Method 'setPrvemp061'.
	 * 
	 * prvemp061 String
	 *
	 * @param prvemp061
	 *            the new prvemp 061
	 */

	public void setPrvemp061(String prvemp061) {
		this.prvemp061 = prvemp061;
	}

	/**
	 * Method 'getMunemp061'.
	 * 
	 * String
	 *
	 * @return the munemp 061
	 */

	public String getMunemp061() {
		return this.munemp061;
	}

	/**
	 * Method 'setMunemp061'.
	 * 
	 * munemp061 String
	 *
	 * @param munemp061
	 *            the new munemp 061
	 */

	public void setMunemp061(String munemp061) {
		this.munemp061 = munemp061;
	}

	/**
	 * Method 'getDmunemp061'.
	 * 
	 * String
	 *
	 * @return the dmunemp 061
	 */

	public String getDmunemp061() {
		return this.dmunemp061;
	}

	/**
	 * Method 'setDmunemp061'.
	 * 
	 * dmunemp061 String
	 *
	 * @param dmunemp061
	 *            the new dmunemp 061
	 */

	public void setDmunemp061(String dmunemp061) {
		this.dmunemp061 = dmunemp061;
	}

	/**
	 * Method 'getDiremp061'.
	 * 
	 * String
	 *
	 * @return the diremp 061
	 */

	public String getDiremp061() {
		return this.diremp061;
	}

	/**
	 * Method 'setDiremp061'.
	 * 
	 * diremp061 String
	 *
	 * @param diremp061
	 *            the new diremp 061
	 */

	public void setDiremp061(String diremp061) {
		this.diremp061 = diremp061;
	}

	/**
	 * Method 'getCpoemp061'.
	 * 
	 * String
	 *
	 * @return the cpoemp 061
	 */

	public String getCpoemp061() {
		return this.cpoemp061;
	}

	/**
	 * Method 'setCpoemp061'.
	 * 
	 * cpoemp061 String
	 *
	 * @param cpoemp061
	 *            the new cpoemp 061
	 */

	public void setCpoemp061(String cpoemp061) {
		this.cpoemp061 = cpoemp061;
	}

	/**
	 * Method 'getTlfemp061'.
	 * 
	 * String
	 *
	 * @return the tlfemp 061
	 */

	public String getTlfemp061() {
		return this.tlfemp061;
	}

	/**
	 * Method 'setTlfemp061'.
	 * 
	 * tlfemp061 String
	 *
	 * @param tlfemp061
	 *            the new tlfemp 061
	 */

	public void setTlfemp061(String tlfemp061) {
		this.tlfemp061 = tlfemp061;
	}

	/**
	 * Method 'getFaxemp061'.
	 * 
	 * String
	 *
	 * @return the faxemp 061
	 */

	public String getFaxemp061() {
		return this.faxemp061;
	}

	/**
	 * Method 'setFaxemp061'.
	 * 
	 * faxemp061 String
	 *
	 * @param faxemp061
	 *            the new faxemp 061
	 */

	public void setFaxemp061(String faxemp061) {
		this.faxemp061 = faxemp061;
	}

	/**
	 * Method 'getEmaemp061'.
	 * 
	 * String
	 *
	 * @return the emaemp 061
	 */

	public String getEmaemp061() {
		return this.emaemp061;
	}

	/**
	 * Method 'setEmaemp061'.
	 * 
	 * emaemp061 String
	 *
	 * @param emaemp061
	 *            the new emaemp 061
	 */

	public void setEmaemp061(String emaemp061) {
		this.emaemp061 = emaemp061;
	}

	/**
	 * Method 'getHttpemp061'.
	 * 
	 * String
	 *
	 * @return the httpemp 061
	 */

	public String getHttpemp061() {
		return this.httpemp061;
	}

	/**
	 * Method 'setHttpemp061'.
	 * 
	 * httpemp061 String
	 *
	 * @param httpemp061
	 *            the new httpemp 061
	 */

	public void setHttpemp061(String httpemp061) {
		this.httpemp061 = httpemp061;
	}

	/**
	 * Method 'getClasctr061'.
	 * 
	 * String
	 *
	 * @return the clasctr 061
	 */

	public String getClasctr061() {
		return this.clasctr061;
	}

	/**
	 * Method 'setClasctr061'.
	 * 
	 * clasctr061 String
	 *
	 * @param clasctr061
	 *            the new clasctr 061
	 */

	public void setClasctr061(String clasctr061) {
		this.clasctr061 = clasctr061;
	}

	/**
	 * Method 'getTrbtot061'.
	 * 
	 * Long
	 *
	 * @return the trbtot 061
	 */

	public Long getTrbtot061() {
		return this.trbtot061;
	}

	/**
	 * Method 'setTrbtot061'.
	 * 
	 * trbtot061 Long
	 *
	 * @param trbtot061
	 *            the new trbtot 061
	 */

	public void setTrbtot061(Long trbtot061) {
		this.trbtot061 = trbtot061;
	}

	/**
	 * Method 'getDeclar061'.
	 * 
	 * String
	 *
	 * @return the declar 061
	 */

	public String getDeclar061() {
		return this.declar061;
	}

	/**
	 * Method 'setDeclar061'.
	 * 
	 * declar061 String
	 *
	 * @param declar061
	 *            the new declar 061
	 */

	public void setDeclar061(String declar061) {
		this.declar061 = declar061;
	}

	/**
	 * Method 'getCardec061'.
	 * 
	 * String
	 *
	 * @return the cardec 061
	 */

	public String getCardec061() {
		return this.cardec061;
	}

	/**
	 * Method 'setCardec061'.
	 * 
	 * cardec061 String
	 *
	 * @param cardec061
	 *            the new cardec 061
	 */

	public void setCardec061(String cardec061) {
		this.cardec061 = cardec061;
	}

	/**
	 * Method 'getFecevr061'.
	 * 
	 * java.util.Date
	 *
	 * @return the fecevr 061
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getFecevr061() {
		return this.fecevr061;
	}

	/**
	 * Method 'setFecevr061'.
	 * 
	 * fecevr061 java.util.Date
	 *
	 * @param fecevr061
	 *            the new fecevr 061
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setFecevr061(Date fecevr061) {
		this.fecevr061 = fecevr061;
	}

	/**
	 * Method 'getDesrie061'.
	 * 
	 * String
	 *
	 * @return the desrie 061
	 */

	public String getDesrie061() {
		return this.desrie061;
	}

	/**
	 * Method 'setDesrie061'.
	 * 
	 * desrie061 String
	 *
	 * @param desrie061
	 *            the new desrie 061
	 */

	public void setDesrie061(String desrie061) {
		this.desrie061 = desrie061;
	}

	/**
	 * Method 'getDesact061'.
	 * 
	 * String
	 *
	 * @return the desact 061
	 */

	public String getDesact061() {
		return this.desact061;
	}

	/**
	 * Method 'setDesact061'.
	 * 
	 * desact061 String
	 *
	 * @param desact061
	 *            the new desact 061
	 */

	public void setDesact061(String desact061) {
		this.desact061 = desact061;
	}

	/**
	 * Method 'getObserv061'.
	 * 
	 * String
	 *
	 * @return the observ 061
	 */

	public String getObserv061() {
		return this.observ061;
	}

	/**
	 * Method 'setObserv061'.
	 * 
	 * observ061 String
	 *
	 * @param observ061
	 *            the new observ 061
	 */

	public void setObserv061(String observ061) {
		this.observ061 = observ061;
	}

	/**
	 * Method 'getCodctr061'.
	 * 
	 * Integer
	 *
	 * @return the codctr 061
	 */

	public Integer getCodctr061() {
		return this.codctr061;
	}

	/**
	 * Method 'setCodctr061'.
	 * 
	 * codctr061 Integer
	 *
	 * @param codctr061
	 *            the new codctr 061
	 */

	public void setCodctr061(Integer codctr061) {
		this.codctr061 = codctr061;
	}

	/**
	 * Method 'getFecalt061'.
	 * 
	 * java.util.Date
	 *
	 * @return the fecalt 061
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getFecalt061() {
		return this.fecalt061;
	}

	/**
	 * Method 'setFecalt061'.
	 * 
	 * fecalt061 java.util.Date
	 *
	 * @param fecalt061
	 *            the new fecalt 061
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setFecalt061(Date fecalt061) {
		this.fecalt061 = fecalt061;
	}

	/**
	 * Method 'getUsualt061'.
	 * 
	 * String
	 *
	 * @return the usualt 061
	 */

	public String getUsualt061() {
		return this.usualt061;
	}

	/**
	 * Method 'setUsualt061'.
	 * 
	 * usualt061 String
	 *
	 * @param usualt061
	 *            the new usualt 061
	 */

	public void setUsualt061(String usualt061) {
		this.usualt061 = usualt061;
	}

	/**
	 * Method 'getFecmod061'.
	 * 
	 * java.util.Date
	 *
	 * @return the fecmod 061
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getFecmod061() {
		return this.fecmod061;
	}

	/**
	 * Method 'setFecmod061'.
	 * 
	 * fecmod061 java.util.Date
	 *
	 * @param fecmod061
	 *            the new fecmod 061
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setFecmod061(Date fecmod061) {
		this.fecmod061 = fecmod061;
	}

	/**
	 * Method 'getUsumod061'.
	 * 
	 * String
	 *
	 * @return the usumod 061
	 */

	public String getUsumod061() {
		return this.usumod061;
	}

	/**
	 * Method 'setUsumod061'.
	 * 
	 * usumod061 String
	 *
	 * @param usumod061
	 *            the new usumod 061
	 */

	public void setUsumod061(String usumod061) {
		this.usumod061 = usumod061;
	}

	/**
	 * Method 'getDescemp061'.
	 * 
	 * String
	 *
	 * @return the descemp 061
	 */

	public String getDescemp061() {
		return this.descemp061;
	}

	/**
	 * Method 'setDescemp061'.
	 * 
	 * descemp061 String
	 *
	 * @param descemp061
	 *            the new descemp 061
	 */

	public void setDescemp061(String descemp061) {
		this.descemp061 = descemp061;
	}

	/**
	 * Method 'getDoccorrecta061'.
	 * 
	 * String
	 *
	 * @return the doccorrecta 061
	 */

	public String getDoccorrecta061() {
		return this.doccorrecta061;
	}

	/**
	 * Method 'setDoccorrecta061'.
	 * 
	 * doccorrecta061 String
	 *
	 * @param doccorrecta061
	 *            the new doccorrecta 061
	 */

	public void setDoccorrecta061(String doccorrecta061) {
		this.doccorrecta061 = doccorrecta061;
	}

	/**
	 * Method 'getEstado061'.
	 * 
	 * String
	 *
	 * @return the estado 061
	 */

	public String getEstado061() {
		return this.estado061;
	}

	/**
	 * Method 'setEstado061'.
	 * 
	 * estado061 String
	 *
	 * @param estado061
	 *            the new estado 061
	 */

	public void setEstado061(String estado061) {
		this.estado061 = estado061;
	}

	/**
	 * Method 'getForpre061'.
	 * 
	 * String
	 *
	 * @return the forpre 061
	 */

	public String getForpre061() {
		return this.forpre061;
	}

	/**
	 * Method 'setForpre061'.
	 * 
	 * forpre061 String
	 *
	 * @param forpre061
	 *            the new forpre 061
	 */

	public void setForpre061(String forpre061) {
		this.forpre061 = forpre061;
	}

	/**
	 * Gets the migrado 061.
	 * 
	 * the migrado061
	 *
	 * @return the migrado 061
	 */
	public String getMigrado061() {
		return migrado061;
	}

	/**
	 * Sets the migrado 061.
	 * 
	 * migrado061 the migrado061 to set
	 *
	 * @param migrado061
	 *            the new migrado 061
	 */
	public void setMigrado061(String migrado061) {
		this.migrado061 = migrado061;
	}

	/**
	 * Gets the folder id 061.
	 * 
	 * the folderid061
	 *
	 * @return the folder id 061
	 */
	public String getFolderId061() {
		return folderid061;
	}

	/**
	 * Sets the folder id 061.
	 * 
	 * folderId061 the folderId061 to set
	 *
	 * @param folderId061
	 *            the new folder id 061
	 */
	public void setFolderId061(String folderId061) {
		this.folderid061 = folderId061;
	}

	/**
	 * Gets the coddatosnotif 061.
	 * 
	 * the coddatosnotif061
	 *
	 * @return the coddatosnotif 061
	 */
	public String getCoddatosnotif061() {
		return coddatosnotif061;
	}

	/**
	 * Sets the coddatosnotif 061.
	 * 
	 * coddatosnotif061 the coddatosnotif061 to set
	 *
	 * @param coddatosnotif061
	 *            the new coddatosnotif 061
	 */
	public void setCoddatosnotif061(String coddatosnotif061) {
		this.coddatosnotif061 = coddatosnotif061;
	}

	/**
	 * Gets the datos notificacion.
	 * 
	 * DatosNotificacion
	 *
	 * @return the datos notificacion
	 */
	public DatosNotificacion getDatosNotificacion() {
		return this.datosNotificacion;
	}

	/**
	 * Sets the datos notificacion.
	 * 
	 * datosNotificacion DatosNotificacion
	 *
	 * @param datosNotificacion
	 *            the new datos notificacion
	 */
	public void setDatosNotificacion(DatosNotificacion datosNotificacion) {
		this.datosNotificacion = datosNotificacion;
	}

	/**
	 * Intended only for logging and debugging.
	 * 
	 * Here, the contents of every main field are placed into the result.
	 * 
	 * String
	 *
	 * @return the string
	 */
	@Override()
	public String toString() {
		StringBuilder result = new StringBuilder();
		result.append(this.getClass().getName()).append(" Object { ");
		// Clave compuesta

		result.append("[ teros3061: ").append(this.teros3061).append(" ]");

		result.append(", [ anoos3061: ").append(this.anoos3061).append(" ]");

		result.append(", [ numos3061: ").append(this.numos3061).append(" ]");
		result.append(", [ fecpre061: ").append(this.fecpre061).append(" ]");
		result.append(", [ fecier061: ").append(this.fecier061).append(" ]");
		result.append(", [ terape061: ").append(this.terape061).append(" ]");
		result.append(", [ anoape061: ").append(this.anoape061).append(" ]");
		result.append(", [ numape061: ").append(this.numape061).append(" ]");
		result.append(", [ nueva061: ").append(this.nueva061).append(" ]");
		result.append(", [ tipdoc061: ").append(this.tipdoc061).append(" ]");
		result.append(", [ numdoc061: ").append(this.numdoc061).append(" ]");
		result.append(", [ nomemp061: ").append(this.nomemp061).append(" ]");
		result.append(", [ paisemp061: ").append(this.paisemp061).append(" ]");
		result.append(", [ prvemp061: ").append(this.prvemp061).append(" ]");
		result.append(", [ munemp061: ").append(this.munemp061).append(" ]");
		result.append(", [ dmunemp061: ").append(this.dmunemp061).append(" ]");
		result.append(", [ diremp061: ").append(this.diremp061).append(" ]");
		result.append(", [ cpoemp061: ").append(this.cpoemp061).append(" ]");
		result.append(", [ tlfemp061: ").append(this.tlfemp061).append(" ]");
		result.append(", [ faxemp061: ").append(this.faxemp061).append(" ]");
		result.append(", [ emaemp061: ").append(this.emaemp061).append(" ]");
		result.append(", [ httpemp061: ").append(this.httpemp061).append(" ]");
		result.append(", [ clasctr061: ").append(this.clasctr061).append(" ]");
		result.append(", [ trbtot061: ").append(this.trbtot061).append(" ]");
		result.append(", [ declar061: ").append(this.declar061).append(" ]");
		result.append(", [ cardec061: ").append(this.cardec061).append(" ]");
		result.append(", [ fecevr061: ").append(this.fecevr061).append(" ]");
		result.append(", [ desrie061: ").append(this.desrie061).append(" ]");
		result.append(", [ desact061: ").append(this.desact061).append(" ]");
		result.append(", [ observ061: ").append(this.observ061).append(" ]");
		result.append(", [ codctr061: ").append(this.codctr061).append(" ]");
		result.append(", [ fecalt061: ").append(this.fecalt061).append(" ]");
		result.append(", [ usualt061: ").append(this.usualt061).append(" ]");
		result.append(", [ fecmod061: ").append(this.fecmod061).append(" ]");
		result.append(", [ usumod061: ").append(this.usumod061).append(" ]");
		result.append(", [ descemp061: ").append(this.descemp061).append(" ]");
		result.append(", [ doccorrecta061: ").append(this.doccorrecta061)
				.append(" ]");
		result.append(", [ estado061: ").append(this.estado061).append(" ]");
		result.append(", [ forpre061: ").append(this.forpre061).append(" ]");
		result.append(", [ migrado061: ").append(this.migrado061).append(" ]");
		result.append(", [ folderid061: ").append(this.folderid061)
				.append(" ]");
		result.append(", [ coddatosnotif061: ").append(this.coddatosnotif061)
				.append(" ]");
		result.append("}");
		return result.toString();
	}

	/**
	 * Convierte ComunicacionPrl en OS3.
	 * 
	 * comunicacionPrl ComunicacionPrl OS3
	 *
	 * @param comunicacionPrl
	 *            the comunicacion prl
	 * @return the os3
	 */
	public static OS3 convertComunicacionPrltoOS3(
			ComunicacionPrl comunicacionPrl) {
		OS3 os3 = new OS3();
		os3.teros3061 = comunicacionPrl.getTeros();
		os3.anoos3061 = comunicacionPrl.getAnoos();
		os3.numos3061 = comunicacionPrl.getNumos();
		os3.fecpre061 = comunicacionPrl.getFecpre();
		os3.fecier061 = comunicacionPrl.getFecier();
		os3.terape061 = comunicacionPrl.getTerape();
		os3.anoape061 = comunicacionPrl.getAnoape();
		os3.numape061 = comunicacionPrl.getNumape();
		os3.tipdoc061 = comunicacionPrl.getTipdoc();
		os3.numdoc061 = comunicacionPrl.getNumdoc();
		os3.nomemp061 = comunicacionPrl.getNomemp();
		os3.paisemp061 = comunicacionPrl.getPaisemp();
		os3.prvemp061 = comunicacionPrl.getPrvemp();
		os3.munemp061 = comunicacionPrl.getMunemp();
		os3.dmunemp061 = comunicacionPrl.getDmunemp();
		os3.diremp061 = comunicacionPrl.getDiremp();
		os3.cpoemp061 = comunicacionPrl.getCpoemp();
		os3.tlfemp061 = comunicacionPrl.getTlfemp();
		os3.faxemp061 = comunicacionPrl.getFaxemp();
		os3.emaemp061 = comunicacionPrl.getEmaemp();
		os3.httpemp061 = comunicacionPrl.getHttpemp();
		os3.clasctr061 = comunicacionPrl.getClasctr();
		os3.trbtot061 = comunicacionPrl.getTrbtot() != null
				? comunicacionPrl.getTrbtot().longValue() : null;
		os3.declar061 = comunicacionPrl.getDeclar();
		os3.cardec061 = comunicacionPrl.getCardec();
		os3.fecevr061 = comunicacionPrl.getFecevr();
		os3.desrie061 = comunicacionPrl.getDesrie();
		os3.desact061 = comunicacionPrl.getDesact();
		os3.observ061 = comunicacionPrl.getObserv();
		os3.codctr061 = comunicacionPrl.getCodctr();
		os3.fecalt061 = comunicacionPrl.getFecalt();
		os3.usualt061 = comunicacionPrl.getUsualt();
		os3.fecmod061 = comunicacionPrl.getFecmod();
		os3.usumod061 = comunicacionPrl.getUsumod();
		os3.descemp061 = comunicacionPrl.getDescemp();
		os3.doccorrecta061 = comunicacionPrl.getDoccorrecta();
		os3.estado061 = comunicacionPrl.getEstado();
		os3.forpre061 = comunicacionPrl.getForpre();
		os3.nueva061 = comunicacionPrl.getNueva();
		os3.migrado061 = comunicacionPrl.getMigrado();
		os3.folderid061 = comunicacionPrl.getFolderId();
		os3.coddatosnotif061 = comunicacionPrl.getCoddatosnotif();
		os3.datosNotificacion = comunicacionPrl.getDatosNotificacion();

		os3.deseaRegistrar061 = comunicacionPrl.getDeseaRegistrar();
		os3.numReg061 = comunicacionPrl.getNumReg();
		os3.fecReg061 = comunicacionPrl.getFecReg();

		os3.tipdocrepresentante061 = comunicacionPrl.getTipdocrepresentante();
		os3.numdocrepresentante061 = comunicacionPrl.getNumdocrepresentante();
		os3.nomrepresentante061 = comunicacionPrl.getNomrepresentante();

		return os3;
	}

	/**
	 * Gets the num expediente.
	 * 
	 * String
	 *
	 * @return the num expediente
	 */
	public String getNumExpediente() {
		StringBuilder sb = new StringBuilder();
		if (this.teros3061 != null && this.anoos3061 != null
				&& this.numos3061 != null) {
			sb.append(this.teros3061);
			sb.append("/");
			sb.append(this.anoos3061);
			sb.append("/");
			sb.append(StringUtils.leftPad(this.numos3061.toString(),
					OS3.NUMEXP_LPAD_SIZE, OS3.NUMEXP_LPAD_CHAR));
		}
		return sb.toString();
	}

	/**
	 * Gets the numdocrepresentante 061.
	 * 
	 * String
	 *
	 * @return the numdocrepresentante 061
	 */
	public String getNumdocrepresentante061() {
		return numdocrepresentante061;
	}

	/**
	 * Sets the numdocrepresentante 061.
	 * 
	 * numdocrepresentante061 String
	 *
	 * @param numdocrepresentante061
	 *            the new numdocrepresentante 061
	 */
	public void setNumdocrepresentante061(String numdocrepresentante061) {
		this.numdocrepresentante061 = numdocrepresentante061;
	}

	/**
	 * Gets the tlfrepresentante 061.
	 * 
	 * String
	 *
	 * @return the tlfrepresentante 061
	 */
	public String getTlfrepresentante061() {
		return tlfrepresentante061;
	}

	/**
	 * Sets the tlfrepresentante 061.
	 * 
	 * tlfrepresentante061 String
	 *
	 * @param tlfrepresentante061
	 *            the new tlfrepresentante 061
	 */
	public void setTlfrepresentante061(String tlfrepresentante061) {
		this.tlfrepresentante061 = tlfrepresentante061;
	}

	/**
	 * Gets the tit repr 061.
	 * 
	 * String
	 *
	 * @return the tit repr 061
	 */
	public String getTitRepr061() {
		return titRepr061;
	}

	/**
	 * Sets the tit repr 061.
	 * 
	 * titRepr061 String
	 *
	 * @param titRepr061
	 *            the new tit repr 061
	 */
	public void setTitRepr061(String titRepr061) {
		this.titRepr061 = titRepr061;
	}

	/**
	 * Gets the nomrepresentante 061.
	 * 
	 * String
	 *
	 * @return the nomrepresentante 061
	 */
	public String getNomrepresentante061() {
		return nomrepresentante061;
	}

	/**
	 * Sets the nomrepresentante 061.
	 * 
	 * nomrepresentante061 String
	 *
	 * @param nomrepresentante061
	 *            the new nomrepresentante 061
	 */
	public void setNomrepresentante061(String nomrepresentante061) {
		this.nomrepresentante061 = nomrepresentante061;
	}

	/**
	 * Gets the tipdocrepresentante 061.
	 * 
	 * String
	 *
	 * @return the tipdocrepresentante 061
	 */
	public String getTipdocrepresentante061() {
		return tipdocrepresentante061;
	}

	/**
	 * Sets the tipdocrepresentante 061.
	 * 
	 * tipdocrepresentante061 String
	 *
	 * @param tipdocrepresentante061
	 *            the new tipdocrepresentante 061
	 */
	public void setTipdocrepresentante061(String tipdocrepresentante061) {
		this.tipdocrepresentante061 = tipdocrepresentante061;
	}

	/**
	 * Gets the lista tramites.
	 * 
	 * List<TramiteOS3>
	 *
	 * @return the lista tramites
	 */
	public List<TramiteOS3> getListaTramites() {
		return this.listaTramites;
	}

	/**
	 * Sets the lista tramites.
	 * 
	 * listaTramites List<TramiteOS3>
	 *
	 * @param listaTramites
	 *            the new lista tramites
	 */
	public void setListaTramites(List<TramiteOS3> listaTramites) {
		this.listaTramites = listaTramites;
	}

	/**
	 * Gets the lista tareas.
	 * 
	 * List<TareaOS3>
	 *
	 * @return the lista tareas
	 */
	public List<TareaOS3> getListaTareas() {
		return this.listaTareas;
	}

	/**
	 * Sets the lista tareas.
	 * 
	 * listaTareas List<TareaOS3>
	 *
	 * @param listaTareas
	 *            the new lista tareas
	 */
	public void setListaTareas(List<TareaOS3> listaTareas) {
		this.listaTareas = listaTareas;
	}

	/**
	 * Gets the fec reg 061.
	 * 
	 * the fecReg
	 *
	 * @return the fec reg 061
	 */
	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getFecReg061() {
		return fecReg061;
	}

	/**
	 * Sets the fec reg 061.
	 * 
	 * fecReg the fecReg to set
	 *
	 * @param fecReg
	 *            the new fec reg 061
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setFecReg061(Date fecReg) {
		this.fecReg061 = fecReg;
	}

	/**
	 * Gets the desea registrar 061.
	 * 
	 * the deseaRegistrar
	 *
	 * @return the desea registrar 061
	 */
	public String getDeseaRegistrar061() {
		return deseaRegistrar061;
	}

	/**
	 * Sets the desea registrar 061.
	 * 
	 * deseaRegistrar the deseaRegistrar to set
	 *
	 * @param deseaRegistrar
	 *            the new desea registrar 061
	 */
	public void setDeseaRegistrar061(String deseaRegistrar) {
		this.deseaRegistrar061 = deseaRegistrar;
	}

	/**
	 * Gets the num reg 061.
	 * 
	 * the numReg
	 *
	 * @return the num reg 061
	 */
	public String getNumReg061() {
		return numReg061;
	}

	/**
	 * Sets the num reg 061.
	 * 
	 * numReg the numReg to set
	 *
	 * @param numReg
	 *            the new num reg 061
	 */
	public void setNumReg061(String numReg) {
		this.numReg061 = numReg;
	}

	/**
	 * Gets the num exp desde.
	 * 
	 * String
	 *
	 * @return the num exp desde
	 */
	public String getNumExpDesde() {
		return numExpDesde;
	}

	/**
	 * Sets the num exp desde.
	 * 
	 * numExpDesde String
	 *
	 * @param numExpDesde
	 *            the new num exp desde
	 */
	public void setNumExpDesde(String numExpDesde) {
		this.numExpDesde = numExpDesde;
	}

	/**
	 * Gets the num exp hasta.
	 * 
	 * String
	 *
	 * @return the num exp hasta
	 */
	public String getNumExpHasta() {
		return numExpHasta;
	}

	/**
	 * Sets the num exp hasta.
	 * 
	 * numExpHasta String
	 *
	 * @param numExpHasta
	 *            the new num exp hasta
	 */
	public void setNumExpHasta(String numExpHasta) {
		this.numExpHasta = numExpHasta;
	}

	/**
	 * Gets the fecpre desde.
	 * 
	 * Date
	 *
	 * @return the fecpre desde
	 */
	public Date getFecpreDesde() {
		return fecpreDesde;
	}

	/**
	 * Sets the fecpre desde.
	 * 
	 * fecpreDesde Date
	 *
	 * @param fecpreDesde
	 *            the new fecpre desde
	 */
	public void setFecpreDesde(Date fecpreDesde) {
		this.fecpreDesde = fecpreDesde;
	}

	/**
	 * Gets the fecpre hasta.
	 * 
	 * Date
	 *
	 * @return the fecpre hasta
	 */
	public Date getFecpreHasta() {
		return fecpreHasta;
	}

	/**
	 * Sets the fecpre hasta.
	 * 
	 * fecpreHasta Date
	 *
	 * @param fecpreHasta
	 *            the new fecpre hasta
	 */
	public void setFecpreHasta(Date fecpreHasta) {
		this.fecpreHasta = fecpreHasta;
	}

	/**
	 * Gets the periodo presentacion.
	 * 
	 * String
	 *
	 * @return the periodo presentacion
	 */
	public String getPeriodoPresentacion() {
		return periodoPresentacion;
	}

	/**
	 * Sets the periodo presentacion.
	 * 
	 * periodoPresentacion String
	 *
	 * @param periodoPresentacion
	 *            the new periodo presentacion
	 */
	public void setPeriodoPresentacion(String periodoPresentacion) {
		this.periodoPresentacion = periodoPresentacion;
	}

	/**
	 * Gets the usuario ape 061.
	 * 
	 * the usuarioApe061
	 *
	 * @return the usuario ape 061
	 */
	public String getUsuarioApe061() {
		return usuarioApe061;
	}

	/**
	 * Sets the usuario ape 061.
	 * 
	 * usuarioApe061 the usuarioApe061 to set
	 *
	 * @param usuarioApe061
	 *            the new usuario ape 061
	 */
	public void setUsuarioApe061(String usuarioApe061) {
		this.usuarioApe061 = usuarioApe061;
	}

	/**
	 * Gets the usuario aport 061.
	 * 
	 * the usuarioAport061
	 *
	 * @return the usuario aport 061
	 */
	public String getUsuarioAport061() {
		return usuarioAport061;
	}

	/**
	 * Sets the usuario aport 061.
	 * 
	 * usuarioAport061 the usuarioAport061 to set
	 *
	 * @param usuarioAport061
	 *            the new usuario aport 061
	 */
	public void setUsuarioAport061(String usuarioAport061) {
		this.usuarioAport061 = usuarioAport061;
	}

	/**
	 * Gets the usuario tram 061.
	 * 
	 * the usuarioTram061
	 *
	 * @return the usuario tram 061
	 */
	public String getUsuarioTram061() {
		return usuarioTram061;
	}

	/**
	 * Sets the usuario tram 061.
	 * 
	 * usuarioTram061 the usuarioTram061 to set
	 *
	 * @param usuarioTram061
	 *            the new usuario tram 061
	 */
	public void setUsuarioTram061(String usuarioTram061) {
		this.usuarioTram061 = usuarioTram061;
	}

	/**
	 * Method 'getFecreq061'.
	 * 
	 * Date
	 * 
	 * @return the fecreq 061
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getFecreq061() {
		return this.fecreq061;
	}

	/**
	 * Method 'setFecreq061'.
	 * 
	 * fecreq061 Date
	 * 
	 * @param fecreq061
	 *            the new fecreq 061
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setFecreq061(Date fecreq061) {
		this.fecreq061 = fecreq061;
	}

	/**
	 * Method 'getFecsub061'.
	 * 
	 * Date
	 * 
	 * @return the fecsub 061
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getFecsub061() {
		return this.fecsub061;
	}

	/**
	 * Method 'setFecsub061'.
	 * 
	 * fecsub061 Date
	 * 
	 * @param fecsub061
	 *            the new fecsub 061
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setFecsub061(Date fecsub061) {
		this.fecsub061 = fecsub061;
	}

}
